/*
 * Decompiled with CFR 0.152.
 */
package betterblockentities.resource.model.models;

import betterblockentities.resource.model.ModelGenerator;
import betterblockentities.resource.model.util.TemplateLoader;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1767;

public class BedModels
extends ModelGenerator {

    public static class BlockState {
        public static void generateBedBlockstates(Map<String, byte[]> map) {
            for (class_1767 color : class_1767.values()) {
                String name = color.method_7792() + "_bed";
                JsonObject variants = new JsonObject();
                String[] facings = new String[]{"north", "south", "west", "east"};
                String[] parts = new String[]{"head", "foot"};
                boolean[] occupiedValues = new boolean[]{false, true};
                for (String facing : facings) {
                    for (String part : parts) {
                        for (boolean occupied : occupiedValues) {
                            String key = String.format("facing=%s,part=%s,occupied=%s", facing, part, occupied);
                            int yRot = switch (facing) {
                                case "south" -> 180;
                                case "west" -> 270;
                                case "east" -> 90;
                                default -> 0;
                            };
                            String model = "minecraft:block/" + name + "_" + part;
                            JsonObject variant = new JsonObject();
                            variant.addProperty("model", model);
                            variant.addProperty("y", (Number)yRot);
                            variants.add(key, (JsonElement)variant);
                        }
                    }
                }
                JsonObject root = new JsonObject();
                root.add("variants", (JsonElement)variants);
                map.put("assets/minecraft/blockstates/" + name + ".json", GSON.toJson((JsonElement)root).getBytes(StandardCharsets.UTF_8));
            }
        }
    }

    public static class Model {
        public static void generateBedsHead(Map<String, byte[]> map) {
            JsonObject template = loader.loadTemplate("bed_head_template.json");
            if (template == null) {
                return;
            }
            List<TemplateLoader.ElementRecord> elements = loader.readTemplateElements(template);
            for (class_1767 color : class_1767.values()) {
                String name = color.method_7792() + "_bed_head";
                String texture = "minecraft:entity/bed/" + color.method_7792();
                map.put("assets/minecraft/models/block/" + name + ".json", GSON.toJson((JsonElement)BedModels.makeModelWithParticle("bed", texture, "minecraft:block/oak_planks", elements)).getBytes(StandardCharsets.UTF_8));
            }
        }

        public static void generateBedsFoot(Map<String, byte[]> map) {
            JsonObject template = loader.loadTemplate("bed_foot_template.json");
            if (template == null) {
                return;
            }
            List<TemplateLoader.ElementRecord> elements = loader.readTemplateElements(template);
            for (class_1767 color : class_1767.values()) {
                String name = color.method_7792() + "_bed_foot";
                String texture = "minecraft:entity/bed/" + color.method_7792();
                map.put("assets/minecraft/models/block/" + name + ".json", GSON.toJson((JsonElement)BedModels.makeModelWithParticle("bed", texture, "minecraft:block/oak_planks", elements)).getBytes(StandardCharsets.UTF_8));
            }
        }
    }
}

